﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Text;

namespace report_maker
{

    // список отчетов
    public class ReportList
    {
        private List<ReportItem> _list = new List<ReportItem>();

        public int Count { get { return _list.Count; } }

        public ReportItem this[int index] { get { return _list[index]; } }

        public ReportList(string filename)
        {
            string[] s = File.ReadAllLines(filename, Encoding.Default);
            for (int i = 0; i < s.Length; i++)
            {
                int p = s[i].IndexOf('#');
                if (p >= 0) s[i] = s[i].Remove(p);
                s[i] = s[i].Trim();
                if (s[i].Length == 0) continue;
                string[] f = s[i].Split('=');
                if (f.Length != 2) continue;
                f[0] = f[0].Trim().ToUpper();
                if (f[0] != "REPORT") continue;
                f[1] = f[1].Trim();
                if (f[1] == "") continue;
                _list.Add(new ReportItem(f[1]));
            }
            Program.log.Add("", "загружен список отчетов, кол-во " + _list.Count.ToString());
        }

        public void RemoveFiles()
        {
            for (int i = 0; i < _list.Count; i++) _list[i].RemoveFiles();
        }
    }

}
