﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Data;
using Stimulsoft.Report;
using alex.db;

namespace report_maker
{

    // отчет
    public class ReportItem
    {
        private my_MssqlDB _db = null;
        private string _fish = "";
        private string _query = "";

        #region public properties

        public string CODE { get; private set; }

        public bool ENABLED { get; private set; }

        #endregion

        #region constructors

        public ReportItem(string s)
        {
            string[] f = s.Split(new char[] { ' ' }, StringSplitOptions.RemoveEmptyEntries);
            if (f.Length < 2)
            {
                CODE = s;
                ENABLED = true;
            }
            else
            {
                CODE = f[0].Trim();
                f[1] = f[1].Trim().ToUpper();
                if (f[1] == "ENABLED") ENABLED = true;
                else if (f[1] == "DISABLED") ENABLED = false;
                else ENABLED = false;
            }
        }

        #endregion

        #region подготовка отчета

        public void Make(DataInterface data, string filename)
        {
            // подконнектимся к базе
            if (_db == null)
            {
                _db= new my_MssqlDB();
                _db.DB_HOST = Program.config.ReadString("db_host", "");
                _db.DB_NAME = Program.config.ReadString("db_name", "");
                _db.DB_LOGIN = Program.config.ReadString("db_login", "");
                _db.DB_PASSWORD = Program.config.ReadString("db_password", "");
                _db.RAISE_EXCEPTION = true;
                _db.Connect();
            }

            // считываем шаблон отчета
            param_db[] p = null;
            if (_fish == "")
            {
                string q = "dbo.report_body_getfromname @p_name";
                p = new param_db[] { new param_db("p_name", CODE) };
                using (DataSet d = _db.ExecuteProcedure_Select_to_DataSet(q, p))
                {
                    DataRow r = d.Tables[0].Rows[0];
                    _fish = (string)r["name"];
                    File.WriteAllBytes(_fish, (byte[])r["body"]);
                    _query = (string)r["qwork"];
                }
            }

            // готовим отчет
            p = new param_db[] {
                new param_db("f_sellers", data.SELLER),
                new param_db("f_goods_categories", data.CATEGORY),
                new param_db("s_providers", data.PROVIDERS),
                new param_db("s_name_brand", data.ORG),
                new param_db("n_hidden", data.HIDDEN),
                new param_db("d_date", DateTime.Today)
            };
            DataSet _data = _db.ExecuteProcedure_Select_to_DataSet(_query, p);
            StiReport rep = new StiReport();
            rep.Load(_fish);
            rep.Compile();
            rep.Dictionary.DataStore.Clear();
            rep.RegData(_data);
            rep.Render(false);
            rep.SaveDocument(filename);
            rep.Dispose();

        }

        #endregion

        #region удалить лишнее

        public void RemoveFiles()
        {
            if (File.Exists(_fish)) File.Delete(_fish);
        }

        #endregion
    }

}
