﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using alex.common;
using alex.service;

namespace report_maker
{
    class Program
    {
        static void Main(string[] args)
        {
            my_LibSetup.Init(args);
            config = new Config();
            log = new Log(config);
            (new work()).Run();
        }

        static public Config config = null;
        static public Log log = null;
    }

    public class work
    {
        private string _repfile = "";
        private ReportList _reports = null;
        private KlientList _klients = null;
        private KMList _kms = null;

        #region выполнить все работы

        // выполнить все работы
        public void Run()
        {
            if (Service.IsExecute()) return;
            Program.log.Start();
            _repfile = my_LibSetup.Args.StrValue("reports", "");
            if (_repfile != "" && File.Exists(_repfile))
            {

                _reports = new ReportList(_repfile);
                _klients = new KlientList(_repfile);
                _kms = new KMList(_repfile);
                if (_klients.Count > 0) _klients.Work(_reports);
                if (_kms.Count > 0) _kms.Work(_reports);
                _reports.RemoveFiles();
            }
            else
            {
                if (_repfile == "") Program.log.Error("укажите ключ reports с именем конфигурационного файла отчетов");
                else if (!File.Exists(_repfile)) Program.log.Error("конфигурационный файл отчетов не найден");
            }
            Program.log.Stop();
        }

        #endregion
    }
}
