﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Text;

namespace report_maker
{

    // список подписчиков-категорийщиков
    public class KMList
    {
        private List<KMItem> _list = new List<KMItem>();

        public int Count { get { return _list.Count; } }

        public KMList(string filename)
        {
            string[] s = File.ReadAllLines(filename, Encoding.Default);
            for (int i = 0; i < s.Length; i++)
            {
                int p = s[i].IndexOf('#');
                if (p >= 0) s[i] = s[i].Remove(p);
                s[i] = s[i].Trim();
                if (s[i].Length == 0) continue;
                string[] f = s[i].Split('=');
                if (f.Length != 2) continue;
                f[0] = f[0].Trim().ToUpper();
                if (f[0] != "KM") continue;
                f[1] = f[1].Trim();
                if (f[1] == "") continue;
                _list.Add(new KMItem(f[1]));
                _list[_list.Count - 1].ID = _list.Count;
            }
        }

        // подшотовить и разослать отчеты
        // потом переделаем на многопоточность
        public bool Work(ReportList reports)
        {
            try
            {
                for (int i = 0; i < _list.Count; i++) _list[i].Work(reports);
            }
            catch (Exception ex)
            {
                Program.log.Error(ex);
                return false;
            }
            return true;
        }
    }

}
