﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Net;
using System.Net.Mail;
using Stimulsoft.Report;

namespace report_maker
{

    // подписчик
    public class KMItem : DataInterface
    {
        #region private variables

        private int _seller = 0;
        private int _category = 0;
        private string _mask = "";
        private string _email = "";

        #endregion

        #region public properties

        // для уникальной идентификации в списке
        public int ID { get; set; }

        #endregion

        #region DataInterface

        public int SELLER { get { return _seller; } }
        public string ORG { get { return ""; } }
        public int CATEGORY { get { return _category; } }
        public string PROVIDERS { get { return ""; } }
        public int HIDDEN { get { return 0; } }

        #endregion

        private string _from = "";
        private string _sender = "";
        private string _host = "";
        private bool _html = true;
        private int _port = 0;
        private bool _ssl = true;
        private int _timeout = 0;
        private string _login = "";
        private string _password = "";

        // конструктор
        public KMItem(string s)
        {
            string[] f = s.Split(new char[] { ' ' }, StringSplitOptions.RemoveEmptyEntries);
            if (f.Length != 4) throw new Exception("ошибка в формате");
            _seller = int.Parse(f[0].Trim());
            _category = int.Parse(f[1].Trim());
            _mask = f[2].Trim();
            _email = f[3].Trim();

            _from = Program.config.ReadString("mail_from", "");
            _sender = Program.config.ReadString("mail_sender", "");
            _html = true;
            _host = Program.config.ReadString("mail_host", "");
            _port = Program.config.ReadInt("mail_port", 0);
            _ssl = Program.config.ReadBool("mail_ssl", false);
            _timeout = Program.config.ReadInt("mail_timeout", 0) * 1000;
            _login = Program.config.ReadString("mail_login", "");
            _password = Program.config.ReadString("mail_password", "");

        }

        // подгтовить комплект отчетов
        public void Work(ReportList reports)
        {
            Program.log.Info("отчеты по км");

            string path = @".\temp_km_"+ID.ToString();
            if (Directory.Exists(path)) Directory.Delete(path, true);
            Directory.CreateDirectory(path);

            // готовим все отчеты
            bool p = false;
            for (int i = 0; i < reports.Count; i++)
            {
                if (_mask.Length < i || _mask[i] != '1') continue;
                if (reports[i].ENABLED)
                {
                    reports[i].Make(this, path + Path.DirectorySeparatorChar + i.ToString());
                    p = true;
                    Program.log.Info("   " + reports[i].CODE);
                }
            }

            // собираем в один отчет
            string fileout = path + Path.DirectorySeparatorChar + "report.pdf";
            if (p)
            {
                StiReport rep = new StiReport();
                rep.RenderedPages.Clear();
                for (int i = 0; i < reports.Count; i++)
                {
                    string f = path + Path.DirectorySeparatorChar + i.ToString();
                    if (File.Exists(f))
                    {
                        StiReport r = new StiReport();
                        r.LoadDocument(f);
                        for (int j = 0; j < r.RenderedPages.Count; j++) rep.RenderedPages.Add(r.RenderedPages[j]);
                    }
                }
                rep.ExportDocument(StiExportFormat.Pdf, fileout);
                rep.Dispose();
                Program.log.Info("  закончили подготовку");
            }

            // отправляем на указанный адрес
            if (File.Exists(fileout) && _email != "")
            {
                // готовим письмо
                MailMessage m = new MailMessage();
                m.From = new MailAddress(_from);
                m.Sender = new MailAddress(_sender);
                string[] s = _email.Split(new char[] { ',', ' ' }, StringSplitOptions.RemoveEmptyEntries);
                for (int i = 0; i < s.Length; i++) m.To.Add(new MailAddress(s[i]));
                m.IsBodyHtml = false;
                m.Subject = "дайджест";
                m.Body = "Отправлено автоматической системой подготовки отчетов.";
                m.Attachments.Add(new Attachment(fileout));

                // отправляем
                SmtpClient client = new SmtpClient();
                client.Host = _host;
                client.Port = _port;
                client.EnableSsl = _ssl;
                client.Timeout = _timeout;
                client.Credentials = new NetworkCredential(_login, _password);
                client.DeliveryMethod = SmtpDeliveryMethod.Network;
                client.Send(m);
                client.Dispose();
                m.Dispose();

                Program.log.Info("  закончили отправку");
            }

            // все удаляем
            Directory.Delete(path, true);
        }
    }

}
